## Prerequisites
- [Docker](https://docs.docker.com/get-started/#download-and-install-docker) with [Docker Compose](https://docs.docker.com/compose/install/)
- An [ngrok](https://ngrok.com/) Authentication token, this can be obtained by creating a free account 
- An [AIQUA](https://aiqua.stg.qgraph.io/analytics_overview) account

## Configuration
Open up `docker-compose.yml` and fill in the environment variable `NGROK_AUTH` (do not include "" quotes):

```yaml
version: "3.7"

services:
  app:
    image: node:12-alpine
    command: sh -c "yarn install && yarn run dev"
    ports:
      - 3000:3000
    working_dir: /app
    volumes:
      - ./app:/app

  ngrok:
    image: wernight/ngrok:latest
    environment:
      NGROK_AUTH: YOUR_NGROK_AUTH_TOKEN
      NGROK_PORT: 3000
      NGROK_LOOK_DOMAIN: host.docker.internal
      NGROK_DEBUG: true
```

## Bootstrap
Execute:

```sh
$ docker-compose up -d
```

To obtain the temporary web app URL generated by ngrok, execute:

```sh
docker-compose logs -f ngrok
```

You should see something like this:

```sh
...
aiqua_web_test_env_bootstrap-ngrok-1  | t=2022-06-27T08:18:14+0000 lvl=info msg="started tunnel" obj=tunnels name="command_line (http)" addr=http://host.docker.internal:3000 url=http://8507-61-216-8-103.ngrok.io
```

Open up the `url` to verify your web app is up and running

## Watch mode
Watch mode is enabled by default. Head to `app/src/public/index.html` and modify the contents of the HTML's body and then reload the site to see your changes reflected
